const express = require('express')
const router = express.Router()

const propertyController = require('../controllers/propertyController');
const PropertyController = new propertyController();
const validateCookieToken = require("../middleware/cookieTokenHandler");
const validateToken = require("../middleware/validateTokenHandler");
const multer = require('multer');
const storage = multer.memoryStorage();
const upload = multer({
    storage: storage,
    limits: {
        fileSize: 5 * 1024 * 1024 // 5MB limit
    }
});

router.post('/', validateToken, upload.any(), PropertyController.create.bind(PropertyController));
router.post('/save', validateToken, upload.any(), PropertyController.save.bind(PropertyController));
router.get('/settings',PropertyController.propertySettings);
router.get('/settingsWithUsers',PropertyController.propertySettingsWithUsers);
router.get('/list', validateCookieToken, PropertyController.list);

/* admin routes */
router.get('/listing', PropertyController.listing);
router.get('/new_listing', PropertyController.newListing);
router.get('/add', PropertyController.add);
router.get('/edit/:id', PropertyController.edit);
router.get('/otaListings/:id', PropertyController.edit);
router.post('/replace-image', validateToken, upload.any(), PropertyController.replaceDisplayImage);
router.post('/delete-image', validateToken, PropertyController.deleteImage);
router.post('/delete-property', validateToken, PropertyController.deleteProperty.bind(PropertyController));
router.post('/upload-image', validateToken, upload.any(), PropertyController.uploadImage.bind(PropertyController));
router.post('/refresh-room-inventory', validateToken, PropertyController.refreshRoomInventory.bind(PropertyController));
router.post('/fix-all-inventories', validateToken, PropertyController.fixAllPropertyInventories.bind(PropertyController));

module.exports = router
