const express = require("express");
const router = express.Router();
const destinationController = require('../controllers/destinationController');
const DestinationController = new destinationController();
const validateCookieToken = require("../middleware/cookieTokenHandler");

const multer = require('multer');
const validateToken = require("../middleware/validateTokenHandler");
const storage = multer.memoryStorage();
const upload = multer({ 
    storage: storage,
    limits: {
        fileSize: 5 * 1024 * 1024 // 5MB limit
    }
});

// Public routes (read-only)
router.get('/', DestinationController.getAllDestinations);
router.get('/list', validateCookieToken, DestinationController.getAllDestinations); // authenticated list
router.get('/:id', DestinationController.getDestinationById);
router.post('/',validateToken, upload.single('photo'), DestinationController.createDestination);
router.put('/:id',validateToken, upload.single('photo'), DestinationController.updateDestination);
router.delete('/:id',validateToken, DestinationController.deleteDestination);

module.exports = router;