const express = require("express");
const router = express.Router();
const collectionController = require('../controllers/collectionController');
const CollectionController = new collectionController();
const validateCookieToken = require("../middleware/cookieTokenHandler");

const multer = require('multer');
const validateToken = require("../middleware/validateTokenHandler");
const storage = multer.memoryStorage();
const upload = multer({ 
    storage: storage,
    limits: {
        fileSize: 5 * 1024 * 1024 // 5MB limit
    }
});

// Public routes (read-only)
router.get('/', CollectionController.getAllCollections);
router.get('/list', validateCookieToken, CollectionController.getAllCollections); // authenticated list
router.get('/:id', CollectionController.getCollectionById);
router.post('/',validateToken, upload.single('icon'), CollectionController.createCollection);
router.put('/:id',validateToken, upload.single('icon'), CollectionController.updateCollection);
router.delete('/:id',validateToken, CollectionController.deleteCollection);

module.exports = router