const express = require("express");
const multer = require("multer");
const {
  createBlog,
  getBlogs,
  getBlog,
  updateBlog,
  deleteBlog,
  getCategories, // Import getCategories
  uploadBlogImage,
  serveBlogImage,
} = require("../controllers/blogController");
const validateToken = require("../middleware/validateTokenHandler");

const storage = multer.memoryStorage();
const upload = multer({ storage });

const router = express.Router();
console.log("blogRoutes.js is being loaded and routes are being defined."); // Add this log

// Public routes (no authentication required)
router.route("/").get(getBlogs); // Get all blogs
router.route("/categories").get(getCategories); // Get categories
router.route("/images/:key(*)").get(serveBlogImage); // Serve inline/editor images
router.route("/:id").get(getBlog); // Get single blog

// Protected routes (authentication required)
router.use(validateToken); // Apply middleware to subsequent routes

router.route("/image-upload").post(upload.single('image'), uploadBlogImage);
router.route("/").post(upload.single('featured_image'), createBlog); // Create blog
router.route("/:id").put(upload.single('featured_image'), updateBlog).delete(deleteBlog); // Update/Delete blog

module.exports = router;
