const express = require('express')
const router = express.Router()

const EzeeHelper = require('../helpers/ezeeHelper');
const ezeeHelper = new EzeeHelper(process.env.EZEE_URL);
const availabilityController = require('../controllers/availabilityController');
const AvailabilityController = new availabilityController(ezeeHelper);
const bookingsController = require('../controllers/bookingsController');
const BookingsController = new bookingsController(ezeeHelper);
const usersController = require('../controllers/usersController');
const UsersController = new usersController;

const { generateToken,check,getProfile, updateProfile} = require("../controllers/usersController");
const validateToken = require("../middleware/validateTokenHandler");
const loggedInGuest = require("../middleware/loggedInGuestHandler");
const hostsController = require('../controllers/hostsController');
const HostsController = new hostsController();
const formsController = require('../controllers/formsController');
const propertyController = require('../controllers/propertyController');
const PropertyController = new propertyController;
const FormsController = new formsController();
const { generateOTPRules, loginWithOTPRules, submitFormRules, hostEnquiryRules, updateProfileRules, createBookingRules } = require("../middleware/validationRules");

router.get('/generateToken', generateToken);
router.post('/checkAvailability', validateToken, function(...args) {
    return AvailabilityController.find(...args)
});
router.post('/homeAvailability', validateToken, function(...args) {
    return AvailabilityController.home(...args)
});
router.post('/availabilityAndDetails', validateToken, function(...args) {
    return AvailabilityController.pricingAndDetails(...args)
});
router.post('/calendarAvailability', function(...args) {
    return AvailabilityController.calendarAvailabilityForProperty(...args)
});
router.post('/generateOTP', generateOTPRules, UsersController.generateGuestOTP);
router.post('/loginWithOTP', loginWithOTPRules, function(...args) {
    return UsersController.guestLoginWithOTP(...args)
});
router.get('/getProfile',validateToken, getProfile);
router.post('/updateProfile',validateToken, updateProfileRules, updateProfile);

router.post('/createBooking',validateToken,loggedInGuest,function(...args){
    return BookingsController.create(...args);
});
router.get('/myTrips',BookingsController.myTrips);
router.post('/concierge',validateToken,loggedInGuest,function(...args){
    return BookingsController.concierge(...args);
});
router.get('/myBooking/:id',validateToken,BookingsController.displayInfo);
router.post('/check',loggedInGuest,check);

router.post('/hostCalculatorSettings',validateToken, function(...args) {
    return HostsController.hostCalculatorSettings(...args)
});
router.post('/generateHostOTP', function(...args) {
    return HostsController.generateOTP(...args)
});
router.post('/hostEnquiry',validateToken, hostEnquiryRules, function(...args) {
    return HostsController.hostEnquiry(...args)
});

router.post('/generateOrderId',validateToken,loggedInGuest,function(...args){
    return BookingsController.generateOrderId(...args);
});

/** called by the ezee booking webhook*/
router.post('/ezeeBookingSync',function(...args){
    return BookingsController.ezeeBookingSync(...args);
});

router.post('/historicalBookings',function(...args){
    return BookingsController.historicalBookings(...args);
});

router.post('/importEzeeSyncLogs',function(...args){
    return BookingsController.importEzeeSyncLogs(...args);
});

/*Import bookings that were missed out by the ezee sync - do 5 at a time*/
router.get('/missedOutBookings', BookingsController.missedOutBookings.bind(BookingsController));

router.get('/formSettings',validateToken,FormsController.formSettings);
router.post('/submitForm',validateToken, submitFormRules, function(...args){
    return FormsController.submitForm(...args);
});
module.exports = router