'use strict';
var pool = require('../config/dbConnection');

class Setting{
    async getSettings(setting,category){
        let query = 'SELECT id,setting,category,description,display,value FROM settings';
        // Check if setting and category parameters are provided
        if (setting !== undefined && category !== undefined) {
            query += ` WHERE setting = '${setting}' AND category = '${category}'`;
        } else if (setting !== undefined) {
            // Check if only setting parameter is provided
            query += ` WHERE setting = '${setting}'`;
        }
        // Execute the query
        const result = await pool.query(query);
        return result[0];
    }

    async hostCalculatorSettings(){
        try {
            const results = await pool.query("select * from earnings_calculator_settings where active = 1");
            return results[0];
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async hostSettingsByParams(location,property_type,bedrooms,pool_type){
        try{
            const results = await pool.query('select * from earnings_calculator_multipliers where active = 1 and setting_id in (?,?,?,?)',[location,property_type,bedrooms,pool_type]);
            return results[0];
        }catch (error){
            console.log(error);
            throw error;
        }
    }

    async list(setting,category){
        let query = 'SELECT id,category,display,value FROM settings';
        // Check if setting and category parameters are provided
        if (setting !== undefined && category !== undefined) {
            query += ` WHERE setting = '${setting}' AND category = '${category}'`;
        } else if (setting !== undefined) {
            // Check if only setting parameter is provided
            query += ` WHERE setting = '${setting}'`;
        }
        // Execute the query
        const result = await pool.query(query);
        return result[0];
    }

    async display(setting,id){
        try {
            const settingRecord = await pool.query("select * from settings where setting = ? and ?",[setting,id]);
            if(settingRecord[0]){
                return settingRecord[0][0].display;
            } else{
                return null;
            }
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async addSetting(values){
        try {
            const result = await pool.query('INSERT INTO settings SET ?', values);
            return result[0].insertId;
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async updateSetting(id, values){
        try {
            const fields = {};
            for (const [key, val] of Object.entries(values)) {
                if (val !== undefined) fields[key] = val;
            }
            const result = await pool.query('UPDATE settings SET ? WHERE id = ?', [fields, id]);
            return result[0];
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async deleteSetting(id){
        try {
            const result = await pool.query('DELETE FROM settings WHERE id = ?', [id]);
            return result[0];
        } catch (error) {
            console.log(error);
            throw error;
        }
    }

    async setWebDiscount(webDiscount){
        try {
            const result = await pool.query("UPDATE settings SET value = ? WHERE setting = 'web_discount'", [webDiscount]);
            return result[0];
        } catch (error) {
            console.log(error);
            throw error;
        }
    }
}
module.exports= Setting;