const dotenv = require("dotenv").config();
const mode = process.env.MODE || "dev";

const accountSid = process.env.TWILIO_ACCOUNT_SID;
const authToken = process.env.TWILIO_AUTH_TOKEN;
const client = require('twilio')(accountSid, authToken);

class TwilioHelper {
	
	async sendSMS(body,from,to){
		client.messages.create({
			body: body,
			from: from,
			to: to
		})
		.then(message => console.log(message.sid)).catch(console.error);
	}
}
module.exports = TwilioHelper;
