const axios = require('axios');
const key = process.env.RAZORPAY_KEY;
const key_secret = process.env.RAZORPAY_SECRET;

class RazorPayHelper {

    async getOrderId(amount,currency){
        let data = JSON.stringify({
            "amount": amount,
            "currency": currency,
            "receipt": "Receipt no. 1",
            "notes": {
              "notes_key_1": "Tea, Earl Grey, Hot",
              "notes_key_2": "Tea, Earl Grey… decaf."
            }
          });
          
          let config = {
            method: 'post',
            maxBodyLength: Infinity,
            url: 'https://api.razorpay.com/v1/orders',
            headers: { 
              'Content-Type': 'application/json', 
              'Authorization': '••••••'
            },
            auth: {
                username: key,
                password: key_secret
            },
            data : data
          };
          try {
            const response = await axios(config);
            return response.data;
        } catch (error) {
            throw error;
        }
    }
}
module.exports = RazorPayHelper;
